Attribute VB_Name = "modAF"
' This module handles the interfacing between the
' DC motors and the AF system.
Option Explicit
Global Const AxialCoilSystem = -1
Global Const TransverseCoilSystem = 1

Public Sub AF_Demagnetize(ByVal AFLevel As Double, Optional ByVal HoldTime As Double = 0)
    Dim SampleCenterAFPosition As Long
    If AFLevel <= 0 Then Exit Sub
    frmAF.Connect
    SampleCenterAFPosition = Int(AFPos + SampleHeight / 2)
    MotorUpDn_Move SampleCenterAFPosition, 2   '  Move somewhat slowly into AF region
    frmDCMotors.TurningMotorRotate 0
    frmAF.CycleWithHold HoldTime, TransverseCoilSystem, AFLevel, AFRampRate
    frmDCMotors.TurningMotorRotate 90
    If Not frmAF.txtWaitingTime = 0 Then DelayTime (frmAF.txtWaitingTime) ' (August 2007 L Carporzen) Allow to wait between each ramp
    frmAF.CycleWithHold HoldTime, TransverseCoilSystem, AFLevel, AFRampRate
    If Not frmAF.txtWaitingTime = 0 Then DelayTime (frmAF.txtWaitingTime) ' (August 2007 L Carporzen) Allow to wait between each ramp
    frmAF.CycleWithHold HoldTime, AxialCoilSystem, AFLevel, AFRampRate
    frmDCMotors.TurningMotorRotate 360
    frmAF.Disconnect
End Sub
